/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.EntryIdentifier;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.InputStreamReader;
import java.util.List;

public abstract class MultiDeletePathRequest
extends BaseFssApiResource {
    @Schema(description="The list of items you want to delete. For each file or folder you want to delete, you need to enter these two parameters:", required=true)
    private List<EntryIdentifier> entryList;
    @Schema(description="This parameter only applies to deleting a folder. If true, all the files and folders within the given folder are deleted.")
    private Boolean recursive;

    public static Class<? extends MultiDeletePathRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_303)) {
            return V303.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static MultiDeletePathRequest create(FssApiVersion apiVersion, List<EntryIdentifier> entryList, Boolean recursive) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_303)) {
            return new V303(entryList, recursive);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static MultiDeletePathRequest create(FssApiVersion apiVersion, InputStreamReader reader) throws AwJsonException, AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_303)) {
            return MultiDeletePathRequest.fromJson(apiVersion, reader, V303.class);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private MultiDeletePathRequest() {
    }

    private MultiDeletePathRequest(List<EntryIdentifier> entryList, Boolean recursive) {
        this.entryList = entryList;
        this.recursive = recursive;
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("entryList", this.entryList, fieldName);
    }

    public List<EntryIdentifier> getEntryList() {
        return this.entryList;
    }

    public Boolean isRecursive() {
        return this.recursive;
    }

    private static class V303
    extends MultiDeletePathRequest {
        private V303() {
        }

        private V303(List<EntryIdentifier> entryList, Boolean recursive) {
            super(entryList, recursive);
        }
    }
}

