/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.google.common.base.Objects;
import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import java.util.List;

public class OfficeOnlineServerInfo
extends BaseFssApiResource {
    private Boolean oosEnabled;
    private List<String> extensions;
    private List<String> editExtensions;

    public static Class<? extends OfficeOnlineServerInfo> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_440)) {
            return V440.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static OfficeOnlineServerInfo create(FssApiVersion apiVersion, Boolean oosEnabled, List<String> extensions, List<String> editExtensions) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_440)) {
            return new V440(apiVersion, oosEnabled, extensions, editExtensions);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private OfficeOnlineServerInfo() {
    }

    private OfficeOnlineServerInfo(Boolean oosEnabled, List<String> extensions, List<String> editExtensions) {
        this.oosEnabled = oosEnabled;
        this.extensions = extensions;
        this.editExtensions = editExtensions;
    }

    public Boolean isOOSEnabled() {
        return this.oosEnabled;
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public List<String> getEditExtensions() {
        return this.editExtensions;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof OfficeOnlineServerInfo)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        OfficeOnlineServerInfo e = (OfficeOnlineServerInfo)o;
        return Objects.equal((Object)this.isOOSEnabled(), (Object)e.isOOSEnabled()) && Objects.equal(this.getExtensions(), e.getExtensions()) && Objects.equal(this.getEditExtensions(), e.getEditExtensions());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.isOOSEnabled(), this.getExtensions(), this.getEditExtensions()});
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V440
    extends OfficeOnlineServerInfo {
        private V440() {
        }

        private V440(FssApiVersion apiVersion, Boolean oosEnabled, List<String> extensions, List<String> editExtensions) {
            super(oosEnabled, extensions, editExtensions);
        }
    }
}

