/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class OwnerInfo
extends BaseFssApiResource {
    @Schema(description="The user's username")
    private String username;
    @Schema(description="The user's display name")
    private String displayName;
    @Schema(description="A unique identifying string assigned to the user by HCP Anywhere")
    private String userId;

    public static Class<? extends OwnerInfo> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static OwnerInfo create(FssApiVersion apiVersion, String username, String displayName, String userId) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, username, displayName, userId);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private OwnerInfo(String username, String displayName, String userId) {
        this.username = username;
        this.displayName = displayName;
        this.userId = userId;
    }

    private OwnerInfo() {
    }

    public String getUsername() {
        return this.username;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUserId() {
        return this.userId;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V300
    extends OwnerInfo {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, String username, String displayName, String userId) {
            super(username, displayName, userId);
        }
    }
}

