/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.InputStreamReader;

public abstract class PathMetadataGetRequest
extends BaseFssApiResource {
    @Schema(description="The path of the file or folder", required=true)
    private String path;
    @Schema(description="Whether to include deleted item. Defaults to false.")
    private Boolean includeDeleted;

    public static Class<? extends PathMetadataGetRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_303)) {
            return V303.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return V211.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static PathMetadataGetRequest create(FssApiVersion apiVersion, String path, Boolean includeDeleted) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_303)) {
            return new V303(path, includeDeleted);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return new V211(path);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static PathMetadataGetRequest create(FssApiVersion apiVersion, InputStreamReader reader) throws AwJsonException, AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return PathMetadataGetRequest.fromJson(apiVersion, reader, V211.class);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private PathMetadataGetRequest() {
    }

    private PathMetadataGetRequest(String path, Boolean includeDeleted) {
        this.path = path;
        this.includeDeleted = includeDeleted;
    }

    public String getPath() {
        return this.path;
    }

    public Boolean getIncludeDeleted() {
        return this.includeDeleted;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("path", this.path, fieldName);
    }

    private static class V303
    extends PathMetadataGetRequest {
        private V303() {
        }

        private V303(String path, Boolean includeDeleted) {
            super(path, includeDeleted);
        }
    }

    private static class V211
    extends PathMetadataGetRequest {
        private V211() {
        }

        private V211(String path) {
            super(path, null);
        }
    }
}

