/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public class PreserveMembershipRequest
extends BaseFssApiResource {
    @Schema(description="The path to the shared or team folder", required=true)
    private String path;
    @Schema(description="Whether to remove the dynamic groups being tracked", required=true)
    private Boolean removeGroups;

    public static Class<? extends PreserveMembershipRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static PreserveMembershipRequest create(FssApiVersion apiVersion, String path, boolean removeGroups) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, path, removeGroups);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private PreserveMembershipRequest() {
    }

    private PreserveMembershipRequest(String path, boolean removeGroups) {
        this.path = path;
        this.removeGroups = removeGroups;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isRemoveGroups() {
        return this.removeGroups;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("path", this.path, fieldName);
        this.validateFieldNotNull("removeGroups", this.removeGroups, fieldName);
    }

    private static class V300
    extends PreserveMembershipRequest {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, String path, boolean removeGroups) {
            super(path, removeGroups);
        }
    }
}

