/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.google.common.base.Objects;
import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public class PrivacyInfo
extends BaseFssApiResource {
    @Schema(description="True if cookie notice is enabled")
    private Boolean cookieNoticeEnabled;
    @Schema(description="Message for cookie to be prompted")
    private String cookieNoticeMessage;
    @Schema(description="Last time cookie message was changed")
    private Long cookieNoticeChangeTime;

    public static Class<? extends PrivacyInfo> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_410)) {
            return V410.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static PrivacyInfo create(FssApiVersion apiVersion, Boolean cookieNoticeEnabled, String cookieNoticeMessage, Long cookieNoticeChangeTime) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_410)) {
            return new V410(apiVersion, cookieNoticeEnabled, cookieNoticeMessage, cookieNoticeChangeTime);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private PrivacyInfo() {
    }

    private PrivacyInfo(Boolean cookieNoticeEnabled, String cookieNoticeMessage, Long cookieNoticeChangeTime) {
        this.cookieNoticeEnabled = cookieNoticeEnabled;
        this.cookieNoticeMessage = cookieNoticeMessage;
        this.cookieNoticeChangeTime = cookieNoticeChangeTime;
    }

    public Boolean isCookieNoticeEnabled() {
        return this.cookieNoticeEnabled;
    }

    public String getCookieNoticeMessage() {
        return this.cookieNoticeMessage;
    }

    public Long getCookieNoticeChangeTime() {
        return this.cookieNoticeChangeTime;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PrivacyInfo)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        PrivacyInfo e = (PrivacyInfo)o;
        return Objects.equal((Object)this.isCookieNoticeEnabled(), (Object)e.isCookieNoticeEnabled()) && Objects.equal((Object)this.getCookieNoticeMessage(), (Object)e.getCookieNoticeMessage()) && Objects.equal((Object)this.getCookieNoticeChangeTime(), (Object)e.getCookieNoticeChangeTime());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.isCookieNoticeEnabled(), this.getCookieNoticeMessage(), this.getCookieNoticeChangeTime()});
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V410
    extends PrivacyInfo {
        private V410() {
        }

        private V410(FssApiVersion apiVersion, Boolean cookieNoticeEnabled, String cookieNoticeMessage, Long cookieNoticeChangeTime) {
            super(cookieNoticeEnabled, cookieNoticeMessage, cookieNoticeChangeTime);
        }
    }
}

