/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.google.common.base.Objects;
import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public class PrivacyPolicyInfo
extends BaseFssApiResource {
    @Schema(description="True if privacy policy is enabled")
    private Boolean privacyPolicyEnabled;
    @Schema(description="Name of privacy policy")
    private String privacyPolicyName;
    @Schema(description="URL of privacy policy")
    private String privacyPolicyUrl;

    public static Class<? extends PrivacyPolicyInfo> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_420)) {
            return V420.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static PrivacyPolicyInfo create(FssApiVersion apiVersion, Boolean privacyPolicyEnabled, String privacyPolicyName, String privacyPolicyUrl) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_420)) {
            return new V420(apiVersion, privacyPolicyEnabled, privacyPolicyName, privacyPolicyUrl);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private PrivacyPolicyInfo() {
    }

    private PrivacyPolicyInfo(Boolean privacyPolicyEnabled, String privacyPolicyName, String privacyPolicyUrl) {
        this.privacyPolicyEnabled = privacyPolicyEnabled;
        this.privacyPolicyName = privacyPolicyName;
        this.privacyPolicyUrl = privacyPolicyUrl;
    }

    public Boolean isPrivacyPolicyEnabled() {
        return this.privacyPolicyEnabled;
    }

    public String getPrivacyPolicyName() {
        return this.privacyPolicyName;
    }

    public String getPrivacyPolicyUrl() {
        return this.privacyPolicyUrl;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PrivacyPolicyInfo)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        PrivacyPolicyInfo e = (PrivacyPolicyInfo)o;
        return Objects.equal((Object)this.isPrivacyPolicyEnabled(), (Object)e.isPrivacyPolicyEnabled()) && Objects.equal((Object)this.getPrivacyPolicyName(), (Object)e.getPrivacyPolicyName()) && Objects.equal((Object)this.getPrivacyPolicyUrl(), (Object)e.getPrivacyPolicyUrl());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.isPrivacyPolicyEnabled(), this.getPrivacyPolicyName(), this.getPrivacyPolicyUrl()});
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V420
    extends PrivacyPolicyInfo {
        private V420() {
        }

        private V420(FssApiVersion apiVersion, Boolean privacyPolicyEnabled, String privacyPolicyName, String privacyPolicyUrl) {
            super(privacyPolicyEnabled, privacyPolicyName, privacyPolicyUrl);
        }
    }
}

