/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.ProviderType;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public class Provider
extends BaseFssApiResource {
    @Schema(description="A unique identifying string assigned to the identity provider by HCP Anywhere", required=true)
    private String id;
    @Schema(description="For Active Directory, this is the name of the Active Directory domain connected to the HCP Anywhere server. For SAML, this is the name of the SAML identity as it is configured on the HCP Anywhere server.", required=true)
    private String name;
    @Schema(description="The type of authentication provider (ACTIVE_DIRECTORY or SAML)", required=true)
    private ProviderType type;

    public static Class<? extends Provider> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static Provider create(FssApiVersion apiVersion, String id, String name, ProviderType type) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, id, name, type);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private Provider(String id, String name, ProviderType type) {
        this.id = id;
        this.name = name;
        this.type = type;
    }

    private Provider() {
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ProviderType getType() {
        return this.type;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V300
    extends Provider {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, String id, String name, ProviderType type) {
            super(id, name, type);
        }
    }
}

