/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.Provider;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

public class ProviderListing
extends BaseFssApiResource {
    @Schema(description="A list of the identity providers for the HCP Anywhere server specified in the request", required=true)
    private List<Provider> providers;
    @Schema(description="True if autocomplete is enabled")
    private boolean autocompleteEnabled;

    public static Class<? extends ProviderListing> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static ProviderListing create(FssApiVersion apiVersion, List<Provider> providers, boolean autocompleteEnabled) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_410)) {
            return new V410(providers, autocompleteEnabled);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(providers);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private ProviderListing(List<Provider> providers, boolean autocompleteEnabled) {
        this.providers = providers;
        this.autocompleteEnabled = autocompleteEnabled;
    }

    private ProviderListing() {
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    public List<Provider> getProviders() {
        return this.providers;
    }

    private static class V300
    extends ProviderListing {
        private V300() {
        }

        private V300(List<Provider> providers) {
            super(providers, true);
        }
    }

    private static class V410
    extends ProviderListing {
        private V410() {
        }

        private V410(List<Provider> providers, boolean autocompleteEnabled) {
            super(providers, autocompleteEnabled);
        }
    }
}

