/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.FileAccessEntry;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

public class ReadAccessListing
extends BaseFssApiResource {
    @Schema(description="A page token is returned in every response and identifies where in the list of access events you are", required=true)
    private String pageToken;
    @Schema(description="The list of access events for the file", required=true)
    private List<FileAccessEntry> entries;

    public static Class<? extends ReadAccessListing> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static ReadAccessListing create(FssApiVersion apiVersion, List<FileAccessEntry> members, String token) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(members, token);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private ReadAccessListing(List<FileAccessEntry> entries, String token) {
        this.entries = entries;
        this.pageToken = token;
    }

    private ReadAccessListing() {
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    public List<FileAccessEntry> getEntries() {
        return this.entries;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    private static class V300
    extends ReadAccessListing {
        private V300(List<FileAccessEntry> members, String token) {
            super(members, token);
        }
    }
}

