/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public class RestorePoint
extends BaseFssApiResource {
    @Schema(description="The point in time")
    private Long point;

    public static Class<? extends RestorePoint> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static RestorePoint create(FssApiVersion apiVersion, long point) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, point);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private RestorePoint(long point) {
        this.point = point;
    }

    private RestorePoint() {
    }

    public Long getPoint() {
        return this.point;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V300
    extends RestorePoint {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, long point) {
            super(point);
        }
    }
}

