/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;

public abstract class SamlRedirectRequest
extends BaseFssApiResource {
    private String id;
    private String location;
    private FssClientType clientType;

    public static Class<? extends SamlRedirectRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static SamlRedirectRequest create(FssApiVersion apiVersion, String id, String location, FssClientType clientType) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(id, location, clientType);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private SamlRedirectRequest(String id, String location, FssClientType clientType) {
        this.id = id;
        this.location = location;
        this.clientType = clientType;
    }

    public String getId() {
        return this.id;
    }

    public String getLocation() {
        return this.location;
    }

    public FssClientType getClientType() {
        return this.clientType;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("id", this.id, fieldName);
    }

    private static class V300
    extends SamlRedirectRequest {
        private V300(String id, String location, FssClientType clientType) {
            super(id, location, clientType);
        }
    }

    public static enum FssClientType {
        PORTAL,
        MSTEAMSTAB,
        CLIENT;

    }
}

