/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.InputStreamReader;

public abstract class SearchPathRequest
extends BaseFssApiResource {
    @Schema(description="The path to the folder in which to search", required=true)
    private String path;
    @Schema(description="The string which is searched for in the folder. Files and folders that match or partially match the string are returned. The string needs be at least 3 characters long. ", required=true)
    private String substring;
    @Schema(description="The maximum number of results for the search to return. The default is 100.")
    private Integer maxResults;
    @Schema(description="If true, both existing and deleted items are returned. If false, only existing files and folders are returned.")
    private Boolean includeDeleted;
    @Schema(description="The point in time at which to search. This needs to be supplied in Unix format in milliseconds.")
    private Long pointInTime;

    public static Class<? extends SearchPathRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return V211.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static SearchPathRequest create(FssApiVersion apiVersion, String path, String substring, Integer maxResults, Boolean includeDeleted, Long pointInTime) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(path, substring, maxResults, includeDeleted, pointInTime);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return new V211(path, substring, maxResults);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static SearchPathRequest create(FssApiVersion apiVersion, InputStreamReader reader) throws AwJsonException, AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return SearchPathRequest.fromJson(apiVersion, reader, V300.class);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return SearchPathRequest.fromJson(apiVersion, reader, V211.class);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private SearchPathRequest() {
    }

    private SearchPathRequest(String path, String substring, Integer maxResults, Boolean includeDeleted, Long pointInTime) {
        this.path = path;
        this.substring = substring;
        this.maxResults = maxResults;
        this.includeDeleted = includeDeleted;
        this.pointInTime = pointInTime;
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("path", this.path, fieldName);
        this.validateFieldNotNull("substring", this.substring, fieldName);
    }

    public String getPath() {
        return this.path;
    }

    public String getSubstring() {
        return this.substring;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public Boolean getIncludeDeleted() {
        return this.includeDeleted;
    }

    public Long getPointInTime() {
        return this.pointInTime;
    }

    private static class V300
    extends SearchPathRequest {
        private V300() {
        }

        private V300(String path, String substring, Integer maxResults, Boolean includeDeleted, Long pointInTime) {
            super(path, substring, maxResults, includeDeleted, pointInTime);
        }
    }

    private static class V211
    extends SearchPathRequest {
        private V211() {
        }

        private V211(String path, String substring, Integer maxResults) {
            super(path, substring, maxResults, null, null);
        }
    }
}

