/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.TeamFolderInfo;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class ShareAlert
extends BaseFssApiResource {
    @Schema(description="A unique number assigned to the shared or team folder by HCP Anywhere", required=true)
    private String fsId;
    @Schema(description="The label of the folder", required=true)
    private String label;
    @Schema(description="The alert message", required=true)
    private String alert;
    @Schema(description="If the item is a team folder, some additional team folder information", required=true)
    private TeamFolderInfo teamFolderInfo;

    public static Class<? extends ShareAlert> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static ShareAlert create(FssApiVersion apiVersion, String fsId, String label, String alert, TeamFolderInfo teamFolderInfo) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, fsId, label, alert, teamFolderInfo);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private ShareAlert() {
    }

    private ShareAlert(String fsId, String label, String alert, TeamFolderInfo teamFolderInfo) {
        this.fsId = fsId;
        this.label = label;
        this.alert = alert;
        this.teamFolderInfo = teamFolderInfo;
    }

    public String getFsId() {
        return this.fsId;
    }

    public String getLabel() {
        return this.label;
    }

    public String getAlert() {
        return this.alert;
    }

    public TeamFolderInfo getTeamFolderInfo() {
        return this.teamFolderInfo;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V300
    extends ShareAlert {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, String fsId, String label, String alert, TeamFolderInfo teamFolderInfo) {
            super(fsId, label, alert, teamFolderInfo);
        }
    }
}

