/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class ShareCreateRequest
extends BaseFssApiResource {
    @Schema(description="The path to the private folder that you want to convert into a shared folder", required=true)
    private String path;
    @Schema(description="The label of the shared folder. Once the shared folder is created, the label cannot be changed. Whenever a new member is invited to the folder, the name of the folder is the folder label by default.", required=true)
    private String label;

    public static Class<? extends ShareCreateRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static ShareCreateRequest create(FssApiVersion apiVersion, String path, String label) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, path, label);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private ShareCreateRequest() {
    }

    private ShareCreateRequest(String path, String label) {
        this.path = path;
        this.label = label;
    }

    public String getPath() {
        return this.path;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("path", this.path, fieldName);
        this.validateFieldNotNull("label", this.label, fieldName);
    }

    private static class V300
    extends ShareCreateRequest {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, String path, String label) {
            super(path, label);
        }
    }
}

