/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.ShareRole;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class ShareInvitation
extends BaseFssApiResource {
    @Schema(description="The person who invited the user to join the folder", required=true)
    private String inviter;
    @Schema(description="A unique number assigned to the shared or team folder by HCP Anywhere", required=true)
    private String fsId;
    @Schema(description="The size of the folder in bytes", required=true)
    private Long size;
    @Schema(description="The folder role of the member (VIEWER, COLLABORATOR, or MANAGER). The role identifies the operations a user can perform in the folder.", required=true)
    private ShareRole role;
    @Schema(description="The label of the shared or team folder", required=true)
    private String label;
    @Schema(description="True if it's an individual invitation otherwise false", required=true)
    private boolean individual;
    @Schema(description="The unique Id of the shared/team folder that the user is invited to")
    private String uniqueId;

    public static Class<? extends ShareInvitation> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_450)) {
            return V450.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_420)) {
            return V420.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static ShareInvitation create(FssApiVersion apiVersion, String inviter, String fsId, Long size, ShareRole role, String label, boolean individual, String uniqueId) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_450)) {
            return new V450(apiVersion, inviter, fsId, size, role, label, individual, uniqueId);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_420)) {
            return new V420(apiVersion, inviter, fsId, size, role, label, individual);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, inviter, fsId, size, role, label);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private ShareInvitation(String inviter, String fsId, Long size, ShareRole role, String label, boolean individual, String uniqueId) {
        this.inviter = inviter;
        this.fsId = fsId;
        this.size = size;
        this.role = role;
        this.label = label;
        this.individual = individual;
        this.uniqueId = uniqueId;
    }

    private ShareInvitation() {
    }

    public String getInviter() {
        return this.inviter;
    }

    @Schema(name="fsId", description="A unique number assigned to the shared or team folder by HCP Anywhere", required=true)
    public String getFilesystemId() {
        return this.fsId;
    }

    public Long getSize() {
        return this.size;
    }

    public ShareRole getRole() {
        return this.role;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isIndividual() {
        return this.individual;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("inviter", this.inviter, fieldName);
        this.validateFieldNotNull("fsId", this.fsId, fieldName);
        this.validateFieldNotNull("size", this.size, fieldName);
        this.validateFieldNotNull("role", (Object)this.role, fieldName);
        this.validateFieldNotNull("label", this.label, fieldName);
    }

    private static class V450
    extends ShareInvitation {
        private V450() {
        }

        private V450(FssApiVersion apiVersion, String inviter, String fsId, Long size, ShareRole role, String label, boolean individual, String uniqueId) {
            super(inviter, fsId, size, role, label, individual, uniqueId);
        }
    }

    private static class V420
    extends ShareInvitation {
        private V420() {
        }

        private V420(FssApiVersion apiVersion, String inviter, String fsId, Long size, ShareRole role, String label, boolean individual) {
            super(inviter, fsId, size, role, label, individual, null);
        }
    }

    private static class V300
    extends ShareInvitation {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, String inviter, String fsId, Long size, ShareRole role, String label) {
            super(inviter, fsId, size, role, label, true, null);
        }
    }
}

