/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class ShareInvitationAcceptRequest
extends BaseFssApiResource {
    @Schema(description="A unique identifying number assigned to the invitation by HCP Anywhere. You can acquire the fsId of an invitation using a share/listInvitations request.", required=true)
    private String fsId;
    @Schema(description="If true, the shared folder and all its contents synchronize with the given user's HCP Anywhere folder. If false, the shared folder does not appear in the given user's HCP Anywhere folder or use space on the user's computer.", required=true)
    private Boolean sync;

    public static Class<? extends ShareInvitationAcceptRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static ShareInvitationAcceptRequest create(FssApiVersion apiVersion, String fsId, Boolean sync) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, fsId, sync);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private ShareInvitationAcceptRequest(String fsId, Boolean sync) {
        this.fsId = fsId;
        this.sync = sync;
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("fsId", this.fsId, fieldName);
        this.validateFieldNotNull("sync", this.sync, fieldName);
    }

    @Schema(name="fsId", description="A unique identifying number assigned to the invitation by HCP Anywhere. You can acquire the fsId of an invitation using a share/listInvitations request.", required=true)
    public String getFilesystemId() {
        return this.fsId;
    }

    public Boolean isSync() {
        return this.sync;
    }

    private static class V300
    extends ShareInvitationAcceptRequest {
        private V300(FssApiVersion apiVersion, String fsId, Boolean sync) {
            super(fsId, sync);
        }
    }
}

