/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class ShareInvitationRejectRequest
extends BaseFssApiResource {
    @Schema(description="A unique identifying number assigned to the invitation by HCP Anywhere. You can acquire an invitations fsId of an invitation using a share/listInvitations request.", required=true)
    private String fsId;

    public static Class<? extends ShareInvitationRejectRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static ShareInvitationRejectRequest create(FssApiVersion apiVersion, String fsId) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, fsId);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private ShareInvitationRejectRequest(String fsId) {
        this.fsId = fsId;
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("fsId", this.fsId, fieldName);
    }

    @Schema(name="fsId", description="A unique identifying number assigned to the invitation by HCP Anywhere. You can acquire the fsId of an invitation using a share/listInvitations request.", required=true)
    public String getFilesystemId() {
        return this.fsId;
    }

    private static class V300
    extends ShareInvitationRejectRequest {
        private V300(FssApiVersion apiVersion, String fsId) {
            super(fsId);
        }
    }
}

