/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.AccountType;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.ShareRole;
import com.hds.hcpaw.fss.api.model.ShareState;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public class ShareInviteSearchEntry
extends BaseFssApiResource {
    @Schema(description="The user's display name. The display name is acquired from the authentication provider (SAML or AD) of that user.", required=true)
    private String displayName;
    @Schema(description="The user's username. The username is acquired from the identity provider (SAML or AD) of that user.", required=true)
    private String name;
    @Schema(description="A unique identifying string assigned to the user by the user's authentication provider (AD or SAML). For AD, this is the user's Security Identifier (SID). ", required=true)
    private String uniqueId;
    @Schema(description="The unique identifying string assigned to the user's authentication provider (AD or SAML) by HCP Anywhere", required=true)
    private String providerId;
    @Schema(description="The folder role of the member (VIEWER, COLLABORATOR, or MANAGER). The role identifies the operations a user can perform in the folder.", required=true)
    private ShareRole role;
    @Schema(description="The user's state within the folder (INVITED, MEMBER, FORMER_MEMBER)", required=true)
    private ShareState state;
    @Schema(description="Identifies whether the returned object is an individual person or a group (USER or GROUP)", required=true)
    private AccountType type;
    @Schema(description="If true, the folder member was invited individually to the folder. If false, the person was invited to the folder as part of a group.", required=true)
    private Boolean individual;
    @Schema(description="The Active Directory domain that contains the user's user account", required=true)
    private String domain;

    public static Class<? extends ShareInviteSearchEntry> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static ShareInviteSearchEntry create(FssApiVersion apiVersion, String userName, String displayName, String uniqueId, String providerId, ShareRole role, ShareState state, AccountType type, Boolean individual, String domain) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(userName, displayName, uniqueId, providerId, role, state, type, individual, domain);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private ShareInviteSearchEntry(String userName, String displayName, String uniqueId, String providerId, ShareRole role, ShareState state, AccountType type, Boolean individual, String domain) {
        this.name = userName;
        this.displayName = displayName;
        this.uniqueId = uniqueId;
        this.providerId = providerId;
        this.role = role;
        this.state = state;
        this.type = type;
        this.individual = individual;
        this.domain = domain;
    }

    private ShareInviteSearchEntry() {
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Schema(name="name", description="The user's username. The username is acquired from the identity provider (SAML or AD) of that user.", required=true)
    public String getUserName() {
        return this.name;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public ShareRole getRole() {
        return this.role;
    }

    public ShareState getState() {
        return this.state;
    }

    public AccountType getType() {
        return this.type;
    }

    public Boolean isIndividual() {
        return this.individual;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("uniqueId", this.uniqueId, fieldName);
        this.validateFieldNotNull("providerId", this.providerId, fieldName);
    }

    private static class V300
    extends ShareInviteSearchEntry {
        private V300() {
        }

        private V300(String userName, String displayName, String uniqueId, String providerId, ShareRole role, ShareState state, AccountType type, Boolean individual, String domain) {
            super(userName, displayName, uniqueId, providerId, role, state, type, individual, domain);
        }
    }
}

