/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class ShareInviteSearchRequest
extends BaseFssApiResource {
    @Schema(description="The path to the shared or team folder", required=true)
    private String path;
    @Schema(description="The string to search for in the HCP Anywhere network", required=true)
    private String filter;

    public static Class<? extends ShareInviteSearchRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static ShareInviteSearchRequest create(FssApiVersion apiVersion, String path, String filter) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(path, filter);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private ShareInviteSearchRequest() {
    }

    private ShareInviteSearchRequest(String path, String filter) {
        this.path = path;
        this.filter = filter;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("path", this.path, fieldName);
        this.validateFieldNotNull("filter", this.filter, fieldName);
    }

    public String getPath() {
        return this.path;
    }

    public String getFilter() {
        return this.filter;
    }

    private static class V300
    extends ShareInviteSearchRequest {
        private V300() {
        }

        private V300(String path, String filter) {
            super(path, filter);
        }
    }
}

