/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.AccountType;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.ShareGroupInfo;
import com.hds.hcpaw.fss.api.model.ShareRole;
import com.hds.hcpaw.fss.api.model.ShareState;
import com.hds.hcpaw.fss.api.model.ShareUserInfo;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class ShareMember
extends BaseFssApiResource {
    @Schema(description="The name of the group which is acquired from the identity provider (SAML or AD) of the HCP Anywhere system", required=true)
    private String name;
    @Schema(description="The unique identifying string assigned to the group by the group's authentication provider (AD or SAML). For AD, this is the user's Security Identifier (SID).", required=true)
    private String uniqueId;
    @Schema(description="The unique identifying string assigned to the group's authentication provider (AD or SAML) by HCP Anywhere", required=true)
    private String providerId;
    @Schema(description="The folder role of the group (VIEWER, COLLABORATOR, or MANAGER). The role identifies the operations a user can perform in the folder.", required=true)
    private ShareRole role;
    @Schema(description="The group's state in the folder (INVITED, MEMBER, FORMER_MEMBER)", required=true)
    private ShareState state;
    @Schema(description="The Active Directory domain that contains the group's user account", required=true)
    private String domain;
    @Schema(description="Identifies whether the returned object is an individual person or a group (USER or GROUP)", required=true)
    private AccountType accountType;
    @Schema(description="This object lists some additional information about the group", required=true)
    private ShareGroupInfo groupInfo;
    @Schema(description="This object lists some additional information about the user", required=true)
    private ShareUserInfo userInfo;

    public static Class<? extends ShareMember> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_303)) {
            return V303.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static ShareMember create(FssApiVersion apiVersion, String name, String uniqueId, String providerId, ShareRole role, ShareState state, String domain, AccountType accountType, ShareUserInfo userInfo, ShareGroupInfo groupInfo) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_303)) {
            return new V303(name, uniqueId, providerId, role, state, domain, accountType, userInfo, groupInfo);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(name, uniqueId, providerId, role, state, domain, accountType, userInfo);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private ShareMember(String name, String uniqueId, String providerId, ShareRole role, ShareState state, String domain, AccountType accountType, ShareUserInfo userInfo, ShareGroupInfo groupInfo) {
        this.name = name;
        this.uniqueId = uniqueId;
        this.providerId = providerId;
        this.role = role;
        this.state = state;
        this.domain = domain;
        this.accountType = accountType;
        this.userInfo = userInfo;
        this.groupInfo = groupInfo;
    }

    private ShareMember() {
    }

    public String getName() {
        return this.name;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public ShareRole getRole() {
        return this.role;
    }

    public ShareState getState() {
        return this.state;
    }

    public String getDomain() {
        return this.domain;
    }

    public AccountType getAccountType() {
        return this.accountType;
    }

    public ShareUserInfo getUserInfo() {
        return this.userInfo;
    }

    public ShareGroupInfo getGroupInfo() {
        return this.groupInfo;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("uniqueId", this.uniqueId, fieldName);
        this.validateFieldNotNull("providerId", this.providerId, fieldName);
    }

    private static class V303
    extends ShareMember {
        private V303() {
        }

        private V303(String name, String uniqueId, String providerId, ShareRole role, ShareState state, String domain, AccountType accountType, ShareUserInfo userInfo, ShareGroupInfo groupInfo) {
            super(name, uniqueId, providerId, role, state, domain, accountType, userInfo, groupInfo);
        }
    }

    private static class V300
    extends ShareMember {
        private V300() {
        }

        private V300(String name, String uniqueId, String providerId, ShareRole role, ShareState state, String domain, AccountType accountType, ShareUserInfo userInfo) {
            super(name, uniqueId, providerId, role, state, domain, accountType, userInfo, null);
        }
    }
}

