/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class ShareMemberListRequest
extends BaseFssApiResource {
    @Schema(description="The path to the shared or team folder", required=true)
    private String path;
    @Schema(description="The page token returned in the body of the previous response. The page token identifies where in the list of members you are. ")
    private String pageToken;
    @Schema(description="The maximum number of items to return in a request. The default is 100.")
    private Integer pageSize;
    @Schema(description="The way in which the items are sorted in the response body:Alphabetically by NAME; by ROLE, (Viewer, Collaborator, and Manager); by STATE, Invited or Member")
    private SortingCriterion sortingCriterion;
    @Schema(description="The direction in which the list is sorted. To ascend through the list of items, enter \"ASC\". To descend through the list of items, enter \"DESC\". ")
    private SortingDirection sortingDirection;

    public static Class<? extends ShareMemberListRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_400)) {
            return V400.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static ShareMemberListRequest create(FssApiVersion apiVersion, String path, String pageToken, Integer pageSize, SortingCriterion criterion, SortingDirection direction) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_400)) {
            return new V400(path, pageToken, pageSize, criterion, direction);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(path, pageToken, pageSize);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private ShareMemberListRequest() {
    }

    private ShareMemberListRequest(String path, String pageToken, Integer pageSize, SortingCriterion criterion, SortingDirection direction) {
        this.path = path;
        this.pageToken = pageToken;
        this.pageSize = pageSize;
        this.sortingCriterion = criterion;
        this.sortingDirection = direction;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("path", this.path, fieldName);
        if (this.pageSize != null) {
            this.validateFieldInRange("pageSize", this.pageSize, 1, Integer.MAX_VALUE, null);
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public SortingCriterion getSortingCriterion() {
        return this.sortingCriterion;
    }

    public SortingDirection getSortingDirection() {
        return this.sortingDirection;
    }

    public static class V400
    extends ShareMemberListRequest {
        private V400() {
        }

        private V400(String path, String pageToken, Integer pageSize, SortingCriterion criterion, SortingDirection direction) {
            super(path, pageToken, pageSize, criterion, direction);
        }
    }

    public static class V300
    extends ShareMemberListRequest {
        private V300() {
        }

        private V300(String path, String pageToken, Integer pageSize) {
            super(path, pageToken, pageSize, null, null);
        }
    }

    public static enum SortingDirection {
        ASC,
        DESC;

    }

    public static enum SortingCriterion {
        NAME,
        ROLE,
        STATE;

    }
}

