/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.ShareMember;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

public class ShareMemberListing
extends BaseFssApiResource {
    @Schema(description="A list of groups in the shared or team folder", required=true)
    private List<ShareMember> members;
    @Schema(description="A page token is returned in every response and identifies where in the list of folder members you are. You can supply this page token in the body of a request to return the next set of folder members.", required=true)
    private String pageToken;

    public static Class<? extends ShareMemberListing> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static ShareMemberListing create(FssApiVersion apiVersion, List<ShareMember> members, String pageToken) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(members, pageToken);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private ShareMemberListing(List<ShareMember> members, String pageToken) {
        this.members = members;
        this.pageToken = pageToken;
    }

    private ShareMemberListing() {
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    public List<ShareMember> getMembers() {
        return this.members;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    private static class V300
    extends ShareMemberListing {
        private V300(List<ShareMember> members, String pageToken) {
            super(members, pageToken);
        }
    }
}

