/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class ShareRemoveMemberRequest
extends BaseFssApiResource {
    @Schema(description="The path to the shared or team folder", required=true)
    private String path;
    @Schema(description="The unique identifying string assigned to the user by the user's authentication provider (AD or SAML). You can acquire a user's uniqueId using a share/invite/search request.", required=true)
    private String uniqueId;
    @Schema(description="The unique identifying string assigned to the user's authentication provider (AD or SAML) by HCP Anywhere. You can acquire a user's providerId using a share/invite/search request.", required=true)
    private String providerId;

    public static Class<? extends ShareRemoveMemberRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static ShareRemoveMemberRequest create(FssApiVersion apiVersion, String path, String uniqueId, String providerId) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, path, uniqueId, providerId);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private ShareRemoveMemberRequest() {
    }

    private ShareRemoveMemberRequest(String path, String uniqueId, String providerId) {
        this.path = path;
        this.uniqueId = uniqueId;
        this.providerId = providerId;
    }

    public String getPath() {
        return this.path;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getProviderId() {
        return this.providerId;
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("path", this.path, fieldName);
        this.validateFieldNotNull("uniqueId", this.uniqueId, fieldName);
        this.validateFieldNotNull("providerId", this.providerId, fieldName);
    }

    private static class V300
    extends ShareRemoveMemberRequest {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, String path, String uniqueId, String providerId) {
            super(path, uniqueId, providerId);
        }
    }
}

