/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class ShareSettingsUpdateRequest
extends BaseFssApiResource {
    @Schema(description="The path to the shared or team folder", required=true)
    private String path;
    @Schema(description="If true, the shared folder and all its contents synchronize with the given user's HCP Anywhere folder. If false, the shared folder does not appear in the given user's HCP Anywhere folder or use space on the user's computer.", required=true)
    private Boolean sync;

    public static Class<? extends ShareSettingsUpdateRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static ShareSettingsUpdateRequest create(FssApiVersion apiVersion, String path, Boolean sync) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, path, sync);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private ShareSettingsUpdateRequest() {
    }

    private ShareSettingsUpdateRequest(String path, Boolean sync) {
        this.path = path;
        this.sync = sync;
    }

    public String getPath() {
        return this.path;
    }

    public Boolean getSync() {
        return this.sync;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("path", this.path, fieldName);
        this.validateFieldNotNull("sync", this.sync, fieldName);
    }

    private static class V300
    extends ShareSettingsUpdateRequest {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, String path, Boolean sync) {
            super(path, sync);
        }
    }
}

