/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public class ShareSyncMembershipRequest
extends BaseFssApiResource {
    @Schema(description="The path to the shared or team folder", required=true)
    private String path;
    @Schema(description="If true, the role of each group member is changed to reflect the role assigned to their group, except when the group member has a role that is more permissive than the group. Permissiveness goes in this order, from lowest to highest: Viewer, Collaborator, Manager.", required=true)
    private Boolean increaseRole;
    @Schema(description="If true, any member of the group that has declined to join, left, or been deleted from the shared folder is re-invited to the folder", required=true)
    private Boolean inviteDeclined;

    public static Class<? extends ShareSyncMembershipRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static ShareSyncMembershipRequest create(FssApiVersion apiVersion, String path, Boolean increaseRole, Boolean inviteDeclined) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, path, increaseRole, inviteDeclined);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private ShareSyncMembershipRequest(String path, Boolean increaseRole, Boolean inviteDeclined) {
        this.path = path;
        this.increaseRole = increaseRole;
        this.inviteDeclined = inviteDeclined;
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("path", this.path, fieldName);
        this.validateFieldNotNull("increaseRole", this.increaseRole, fieldName);
        this.validateFieldNotNull("inviteDeclined", this.inviteDeclined, fieldName);
    }

    public String getPath() {
        return this.path;
    }

    public Boolean isIncreaseRole() {
        return this.increaseRole;
    }

    public Boolean isInviteDeclined() {
        return this.inviteDeclined;
    }

    private static class V300
    extends ShareSyncMembershipRequest {
        private V300(FssApiVersion apiVersion, String path, Boolean increaseRole, Boolean inviteDeclined) {
            super(path, increaseRole, inviteDeclined);
        }
    }
}

