/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public class ShareUserInfo
extends BaseFssApiResource {
    private Boolean individual;
    @Schema(description="The group's display name is acquired from the authentication provider (SAML or AD) of the HCP Anywhere system", required=true)
    private String displayName;

    public static Class<? extends ShareUserInfo> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static ShareUserInfo create(FssApiVersion apiVersion, Boolean individual, String displayName) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(individual, displayName);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private ShareUserInfo(Boolean individual, String displayName) {
        this.individual = individual;
        this.displayName = displayName;
    }

    private ShareUserInfo() {
    }

    public boolean isIndividual() {
        return this.individual;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V300
    extends ShareUserInfo {
        private V300() {
        }

        private V300(Boolean individual, String displayName) {
            super(individual, displayName);
        }
    }
}

