/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.FilesystemType;
import com.hds.hcpaw.fss.api.model.OwnerInfo;
import com.hds.hcpaw.fss.api.model.ShareRole;
import com.hds.hcpaw.fss.api.model.TeamFolderInfo;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class SharedFolder
extends BaseFssApiResource {
    @Schema(description="The path to the shared or team folder", required=true)
    private String path;
    @Schema(description="The type of shared folder (SHARED or TEAM)", required=true)
    private FilesystemType type;
    @Schema(description="The label of the shared or team folder", required=true)
    private String label;
    @Schema(description="True if the collaborative folder is synced with users HCP Anywhere desktop application", required=true)
    private Boolean sync;
    @Schema(description="The role of the folder. The folder role is always \"MANAGER\".")
    private ShareRole role;
    @Schema(description="The size of the folder in bytes", required=true)
    private Long size;
    @Schema(description="Information about the Owner of the shared folder is returned. The person who creates the shared folder is the Owner of the folder and manages folder membership.")
    private OwnerInfo owner;
    @Schema(description="If the folder is a team folder, some additional team folder settings")
    private TeamFolderInfo teamFolder;
    @Schema(description="If the request is for a team folder, some additional team folder information")
    private TeamFolderInfo teamFolderRequest;
    @Schema(description="The unique Id of the root folder within the shared/team folder file system")
    private String uniqueId;

    public static Class<? extends SharedFolder> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_450)) {
            return V450.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static SharedFolder create(FssApiVersion apiVersion, String path, FilesystemType type, String label, Boolean sync, ShareRole role, Long size, OwnerInfo owner, TeamFolderInfo teamFolder, TeamFolderInfo teamFolderRequest, String uniqueId) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_450)) {
            return new V450(apiVersion, path, type, label, sync, role, size, owner, teamFolder, teamFolderRequest, uniqueId);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, path, type, label, sync, role, size, owner, teamFolder, teamFolderRequest, uniqueId);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private SharedFolder() {
    }

    private SharedFolder(String path, FilesystemType type, String label, Boolean sync, ShareRole role, Long size, OwnerInfo owner, TeamFolderInfo teamFolder, TeamFolderInfo teamFolderRequest, String uniqueId) {
        this.path = path;
        this.type = type;
        this.label = label;
        this.sync = sync;
        this.role = role;
        this.size = size;
        this.owner = owner;
        this.teamFolder = teamFolder;
        this.teamFolderRequest = teamFolderRequest;
        this.uniqueId = uniqueId;
    }

    public String getPath() {
        return this.path;
    }

    public FilesystemType getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public Boolean getSync() {
        return this.sync;
    }

    public ShareRole getRole() {
        return this.role;
    }

    public Long getSize() {
        return this.size;
    }

    public OwnerInfo getOwner() {
        return this.owner;
    }

    public TeamFolderInfo getTeamFolder() {
        return this.teamFolder;
    }

    public TeamFolderInfo getTeamFolderRequest() {
        return this.teamFolderRequest;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V300
    extends SharedFolder {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, String path, FilesystemType type, String label, Boolean sync, ShareRole role, Long size, OwnerInfo owner, TeamFolderInfo teamFolder, TeamFolderInfo teamFolderRequest, String uniqueId) {
            super(path, type, label, sync, role, size, owner, teamFolder, teamFolderRequest, uniqueId);
        }
    }

    private static class V450
    extends V300 {
        private V450(FssApiVersion apiVersion, String path, FilesystemType type, String label, Boolean sync, ShareRole role, Long size, OwnerInfo owner, TeamFolderInfo teamFolder, TeamFolderInfo teamFolderRequest, String uniqueId) {
            super(apiVersion, path, type, label, sync, role, size, owner, teamFolder, teamFolderRequest, uniqueId);
        }
    }
}

