/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class TeamFolderCreateRequest
extends BaseFssApiResource {
    @Schema(description="The path to the folder to convert into a team folder", required=true)
    private String path;
    @Schema(description="The label of the team folder. Once the team folder is created, the label cannot be changed. When a new member is invited to the folder, the name of the folder will be, by default, the folder label.", required=true)
    private String label;
    @Schema(description="The contact information for the team folder (for example, an email or a phone number). The contact information is available to all the folder members.", required=true)
    private String contact;
    @Schema(description="The total storage capacity of the team folder in bytes", required=true)
    private Long quotaBytes;

    public static Class<? extends TeamFolderCreateRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static TeamFolderCreateRequest create(FssApiVersion apiVersion, String path, String label, String contact, Long quotaBytes) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, path, label, contact, quotaBytes);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private TeamFolderCreateRequest(String path, String label, String contact, Long quotaBytes) {
        this.path = path;
        this.label = label;
        this.contact = contact;
        this.quotaBytes = quotaBytes;
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("path", this.path, fieldName);
        this.validateFieldNotNull("label", this.label, fieldName);
        this.validateFieldNotNull("contact", this.contact, fieldName);
        this.validateFieldNotNull("quota", this.quotaBytes, fieldName);
    }

    public String getPath() {
        return this.path;
    }

    public String getLabel() {
        return this.label;
    }

    public String getContact() {
        return this.contact;
    }

    public Long getQuotaBytes() {
        return this.quotaBytes;
    }

    private static class V300
    extends TeamFolderCreateRequest {
        private V300(FssApiVersion apiVersion, String path, String label, String contact, Long quotaBytes) {
            super(path, label, contact, quotaBytes);
        }
    }
}

