/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.TeamFolderType;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class TeamFolderInfo
extends BaseFssApiResource {
    @Schema(description="The contact of the team folder", required=true)
    private String contact;
    @Schema(description="The total storage capacity of the team folder (returned in bytes)", required=true)
    private Long quota;
    @Schema(description="The type of item (CLASSIC, HOME, or GROUP)")
    private TeamFolderType type;

    public static Class<? extends TeamFolderInfo> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_400)) {
            return V400.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static TeamFolderInfo create(FssApiVersion apiVersion, String contact, Long quota, TeamFolderType type) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_400)) {
            return new V400(apiVersion, contact, quota, type);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, contact, quota);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private TeamFolderInfo() {
    }

    private TeamFolderInfo(String contact, Long quota, TeamFolderType type) {
        this.type = type;
        this.contact = contact;
        this.quota = quota;
    }

    public String getContact() {
        return this.contact;
    }

    public Long getQuota() {
        return this.quota;
    }

    public TeamFolderType getType() {
        return this.type;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("contact", this.contact, fieldName);
        this.validateFieldNotNull("quota", this.quota, fieldName);
    }

    private static class V300
    extends TeamFolderInfo {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, String contact, Long quota) {
            super(contact, quota, TeamFolderType.CLASSIC);
        }
    }

    private static class V400
    extends TeamFolderInfo {
        private V400() {
        }

        private V400(FssApiVersion apiVersion, String contact, Long quota, TeamFolderType type) {
            super(contact, quota, type);
        }
    }
}

