/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public class TeamFolderSettings
extends BaseFssApiResource {
    @Schema(description="Whether team folders are enabled for the user")
    private Boolean enabled;
    @Schema(description="The quota threshold for the user")
    private Long teamFolderQuotaThreshold;

    public static Class<? extends TeamFolderSettings> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static TeamFolderSettings create(FssApiVersion apiVersion, Boolean enabled, Long teamFolderQuotaThreshold) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, enabled, teamFolderQuotaThreshold);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private TeamFolderSettings(Boolean enabled, Long teamFolderQuotaThreshold) {
        this.enabled = enabled;
        this.teamFolderQuotaThreshold = teamFolderQuotaThreshold;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Long getTeamFolderQuotaThreshold() {
        return this.teamFolderQuotaThreshold;
    }

    private TeamFolderSettings() {
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V300
    extends TeamFolderSettings {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, Boolean enabled, Long teamFolderQuotaThreshold) {
            super(enabled, teamFolderQuotaThreshold);
        }
    }
}

