/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.AccountSettings;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.ConfigSettings;
import com.hds.hcpaw.fss.api.model.LinkSettings;
import com.hds.hcpaw.fss.api.model.TeamFolderSettings;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class User
extends BaseFssApiResource {
    @Schema(description="Username of the user")
    private String username;
    @Schema(description="Display name of the user")
    private String displayName;
    @Schema(description="ID of the user")
    private String userId;
    @Schema(description="The unique auth ID for the user given by their auth provider")
    private String uniqueId;
    @Schema(description="Number of bytes that the user can store as active versions on Anywhere")
    private Long quotaBytes;
    @Schema(description="Number of bytes currently used by the user's active versions of files on HCP Anywhere")
    private Long usageBytes;
    @Schema(description="Whether or not the user has an email address specified by their auth provider")
    private Boolean hasAuthProviderEmail;
    @Schema(description="Email address of the user")
    private String email;
    @Schema(description="Link settings of the user")
    private LinkSettings linkSettings;
    @Schema(description="Account settings of the user")
    private AccountSettings accountSettings;
    @Schema(description="Team folder specific settings of the user")
    private TeamFolderSettings teamFolderSettings;
    @Schema(description="Number of files")
    private Long fileCount;
    @Schema(description="Number of directories")
    private Long directoryCount;
    @Schema(description="Number of conflicts")
    private Long conflicts;
    @Schema(description="Whether or not the user is allowed to share")
    private Boolean sharingEnabled;
    @Schema(description="Whether the user is registered/enabled")
    private Boolean registered;
    @Schema(description="Configuration specific settings for the user")
    private ConfigSettings configSettings;
    @Schema(description="Whether or not an upgrade is occurring")
    private Boolean inUpgrade;
    @Schema(description="The user's auth provider's ID")
    private String providerId;
    @Schema(description="The user's auth provider type")
    private String providerType;
    private Boolean isGlobalLogout;

    public static Class<? extends User> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return V211.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static User create(FssApiVersion apiVersion, String username, Long quotaBytes, Long usageBytes, String email, LinkSettings linkSettings, AccountSettings accountSettings, Long fileCount, Boolean hasAuthProviderEmail, Long directoryCount, Long conflicts, String displayName, String userId, String uniqueId, Boolean sharingEnabled, Boolean isRegistered, TeamFolderSettings teamFolderSettings, ConfigSettings configSettings, Boolean inUpgrade, String providerId, String providerType, Boolean isGlobalLogout) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_303)) {
            return new V303(apiVersion, username, quotaBytes, usageBytes, email, linkSettings, accountSettings, fileCount, hasAuthProviderEmail, directoryCount, conflicts, displayName, userId, uniqueId, sharingEnabled, isRegistered, teamFolderSettings, configSettings, inUpgrade, providerId, providerType, isGlobalLogout);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, username, quotaBytes, usageBytes, email, linkSettings, accountSettings, fileCount, hasAuthProviderEmail, directoryCount, conflicts, displayName, userId, sharingEnabled, isRegistered, teamFolderSettings, configSettings, inUpgrade);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return new V211(apiVersion, username, quotaBytes, usageBytes, email, linkSettings);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private User(String username, Long quotaBytes, Long usageBytes, String email, LinkSettings linkSettings, AccountSettings accountSettings, Long fileCount, Boolean hasAuthProviderEmail, Long directoryCount, Long conflicts, String displayName, String userId, String uniqueId, Boolean sharingEnabled, Boolean isRegistered, TeamFolderSettings teamFolderSettings, ConfigSettings configSettings, Boolean inUpgrade, String providerId, String providerType, Boolean isGlobalLogout) {
        this.username = username;
        this.displayName = displayName;
        this.userId = userId;
        this.quotaBytes = quotaBytes;
        this.usageBytes = usageBytes;
        this.email = email;
        this.linkSettings = linkSettings;
        this.accountSettings = accountSettings;
        this.fileCount = fileCount;
        this.hasAuthProviderEmail = hasAuthProviderEmail;
        this.directoryCount = directoryCount;
        this.conflicts = conflicts;
        this.sharingEnabled = sharingEnabled;
        this.registered = isRegistered;
        this.teamFolderSettings = teamFolderSettings;
        this.configSettings = configSettings;
        this.inUpgrade = inUpgrade;
        this.uniqueId = uniqueId;
        this.providerId = providerId;
        this.providerType = providerType;
        this.isGlobalLogout = isGlobalLogout;
    }

    private User() {
    }

    public String getUsername() {
        return this.username;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public Long getQuotaBytes() {
        return this.quotaBytes;
    }

    public Long getUsageBytes() {
        return this.usageBytes;
    }

    public String getEmail() {
        return this.email;
    }

    public LinkSettings getLinkSettings() {
        return this.linkSettings;
    }

    public AccountSettings getAccountSettings() {
        return this.accountSettings;
    }

    public Long getFileCount() {
        return this.fileCount;
    }

    public Boolean getHasAuthProviderEmail() {
        return this.hasAuthProviderEmail;
    }

    public Long getDirectoryCount() {
        return this.directoryCount;
    }

    public Long getConflicts() {
        return this.conflicts;
    }

    public Boolean getSharingEnabled() {
        return this.sharingEnabled;
    }

    public Boolean getRegistered() {
        return this.registered;
    }

    public TeamFolderSettings getTeamFolderSettings() {
        return this.teamFolderSettings;
    }

    public ConfigSettings getConfigSettings() {
        return this.configSettings;
    }

    public Boolean getInUpgrade() {
        return this.inUpgrade;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public String getProviderType() {
        return this.providerType;
    }

    @Schema(name="isGlobalLogout", description="The user's auth provider logout type")
    public Boolean isGlobalLogout() {
        return this.isGlobalLogout;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V303
    extends User {
        private V303() {
        }

        private V303(FssApiVersion apiVersion, String username, Long quotaBytes, Long usageBytes, String email, LinkSettings linkSettings, AccountSettings accountSettings, Long fileCount, Boolean hasAuthProviderEmail, Long directoryCount, Long conflicts, String displayName, String userId, String uniqueId, Boolean sharingEnabled, Boolean isRegistered, TeamFolderSettings teamFolderSettings, ConfigSettings configSettings, Boolean inUpgrade, String providerId, String providerType, Boolean isGlobalLogout) {
            super(username, quotaBytes, usageBytes, email, linkSettings, accountSettings, fileCount, hasAuthProviderEmail, directoryCount, conflicts, displayName, userId, uniqueId, sharingEnabled, isRegistered, teamFolderSettings, configSettings, inUpgrade, providerId, providerType, isGlobalLogout);
        }
    }

    private static class V300
    extends User {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, String username, Long quotaBytes, Long usageBytes, String email, LinkSettings linkSettings, AccountSettings accountSettings, Long fileCount, Boolean hasAuthProviderEmail, Long directoryCount, Long conflicts, String displayName, String userId, Boolean sharingEnabled, Boolean isRegistered, TeamFolderSettings teamFolderSettings, ConfigSettings configSettings, Boolean inUpgrade) {
            super(username, quotaBytes, usageBytes, email, linkSettings, accountSettings, fileCount, hasAuthProviderEmail, directoryCount, conflicts, displayName, userId, null, sharingEnabled, isRegistered, teamFolderSettings, configSettings, inUpgrade, null, null, null);
        }
    }

    private static class V211
    extends User {
        private V211() {
        }

        private V211(FssApiVersion apiVersion, String username, Long quotaBytes, Long usageBytes, String email, LinkSettings linkSettings) {
            super(username, quotaBytes, usageBytes, email, linkSettings, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
    }
}

