/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.google.common.base.Strings;
import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class UserSettingsUpdateRequest
extends BaseFssApiResource {
    @Schema(description="The user's email address")
    private String email;
    @Schema(description="If true, the user is sent an email when their HCP Anywhere storage is nearing capacity")
    private Boolean emailQuota;
    @Schema(description="If true, the user is sent an email when a device is registered to your account")
    private Boolean emailDevices;
    @Schema(description="If true, the user is sent an email when their is a login failure for their account")
    private Boolean emailAuth;
    @Schema(description="If true, the user is sent an email when one of your files or folders are accessed through a link")
    private Boolean emailShareFile;
    @Schema(description="If true, the user is sent an email when someone uploads a file to a folder that is accessed through a link that the user shared")
    private Boolean emailUpload;
    @Schema(description="If true, the user is sent an email when they are invited to a shared or team folder")
    private Boolean emailShareFolder;
    @Schema(description="The display language for the user's HCP Anywhere User Portal")
    private String language;
    @Schema(description="If true, on clicking on a Office file in User Portal, the file will be opened in MS Office instead of downloading it.")
    private Boolean openFilesOnClick;
    @Schema(description="If true, guide page will be shown to user.")
    private Boolean showSingleClickUserGuide;

    public static Class<? extends UserSettingsUpdateRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static UserSettingsUpdateRequest create(FssApiVersion apiVersion, String email, Boolean emailQuota, Boolean emailDevices, Boolean emailAuth, Boolean emailShareFile, Boolean emailUpload, Boolean emailShareFolder, String language, Boolean openFilesonClick, Boolean showSingleClickUserGuide) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_440)) {
            return new V440(email, emailQuota, emailDevices, emailAuth, emailShareFile, emailUpload, emailShareFolder, language, openFilesonClick, showSingleClickUserGuide);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(email, emailQuota, emailDevices, emailAuth, emailShareFile, emailUpload, emailShareFolder, language);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private UserSettingsUpdateRequest(String email, Boolean emailQuota, Boolean emailDevices, Boolean emailAuth, Boolean emailShareFile, Boolean emailUpload, Boolean emailShareFolder, String language, Boolean openFilesOnClick, Boolean showSingleClickUserGuide) {
        this.email = email;
        this.emailQuota = emailQuota;
        this.emailDevices = emailDevices;
        this.emailAuth = emailAuth;
        this.emailShareFile = emailShareFile;
        this.emailUpload = emailUpload;
        this.emailShareFolder = emailShareFolder;
        this.language = language;
        this.openFilesOnClick = openFilesOnClick;
        this.showSingleClickUserGuide = showSingleClickUserGuide;
    }

    private UserSettingsUpdateRequest() {
    }

    public String getEmail() {
        return this.email;
    }

    public Boolean getEmailQuota() {
        return this.emailQuota;
    }

    public Boolean getEmailDevices() {
        return this.emailDevices;
    }

    public Boolean getEmailAuth() {
        return this.emailAuth;
    }

    public Boolean getEmailShareFile() {
        return this.emailShareFile;
    }

    public Boolean getEmailUpload() {
        return this.emailUpload;
    }

    public Boolean getEmailShareFolder() {
        return this.emailShareFolder;
    }

    public String getLanguage() {
        return this.language;
    }

    public Boolean getOpenFilesOnClick() {
        return this.openFilesOnClick;
    }

    public Boolean isShowSingleClickUserGuide() {
        return this.showSingleClickUserGuide;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        if (!Strings.isNullOrEmpty((String)this.language)) {
            this.validateLocale("language", this.language, null);
        }
    }

    private static class V440
    extends UserSettingsUpdateRequest {
        private V440() {
        }

        private V440(String email, Boolean emailQuota, Boolean emailDevices, Boolean emailAuth, Boolean emailShareFile, Boolean emailUpload, Boolean emailShareFolder, String language, Boolean openFilesOnClick, Boolean showSingleClickUserGuide) {
            super(email, emailQuota, emailDevices, emailAuth, emailShareFile, emailUpload, emailShareFolder, language, openFilesOnClick, showSingleClickUserGuide);
        }
    }

    private static class V300
    extends UserSettingsUpdateRequest {
        private V300() {
        }

        private V300(String email, Boolean emailQuota, Boolean emailDevices, Boolean emailAuth, Boolean emailShareFile, Boolean emailUpload, Boolean emailShareFolder, String language) {
            super(email, emailQuota, emailDevices, emailAuth, emailShareFile, emailUpload, emailShareFolder, language, false, false);
        }
    }
}

