/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.version;

import com.google.common.base.Preconditions;
import com.hds.commons.version.Version;
import com.hds.commons.version.VersionKey;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;

public enum FssApiVersion implements VersionKey<FssApiVersion>
{
    UNSET("0.0.0"),
    VERSION_211("2.1.1"),
    VERSION_300("3.0.0"),
    VERSION_303("3.0.3"),
    VERSION_310("3.1.0"),
    VERSION_400("4.0.0"),
    VERSION_410("4.1.0"),
    VERSION_420("4.2.0"),
    VERSION_430("4.3.0"),
    VERSION_432("4.3.2"),
    VERSION_440("4.4.0"),
    VERSION_450("4.5.0");

    private final String versionString;
    private final Version versionValue;

    private FssApiVersion(String versionString) {
        Preconditions.checkNotNull((Object)versionString);
        this.versionString = versionString;
        this.versionValue = Version.create(versionString);
    }

    public static FssApiVersion getLatest() {
        return VERSION_450;
    }

    public static FssApiVersion getOldest() {
        return VERSION_211;
    }

    @Override
    public boolean isGreaterThanOrEqualTo(FssApiVersion version) {
        return this.versionValue.isGreaterThanOrEqualTo(version.versionValue);
    }

    @Override
    public boolean isGreaterThan(FssApiVersion version) {
        return this.versionValue.isGreaterThan(version.versionValue);
    }

    @Override
    public boolean isLessThanOrEqualTo(FssApiVersion version) {
        return this.versionValue.isLessThanOrEqualTo(version.versionValue);
    }

    @Override
    public boolean isLessThan(FssApiVersion version) {
        return this.versionValue.isLessThan(version.versionValue);
    }

    @Override
    public String getVersionString() {
        return this.versionString;
    }

    public Version getVersion() {
        return this.versionValue;
    }

    public static FssApiVersion getValueFromVersionString(String versionString) {
        if (versionString == null) {
            return UNSET;
        }
        versionString = versionString.trim();
        for (FssApiVersion curr : FssApiVersion.values()) {
            if (!versionString.equals(curr.getVersionString())) continue;
            return curr;
        }
        return UNSET;
    }

    public static Set<FssApiVersion> getValuesFromStringSet(Set<String> versionStrings) {
        return versionStrings.stream().map(FssApiVersion::getValueFromVersionString).collect(Collectors.toSet());
    }

    public String toString() {
        return this.versionString;
    }

    public static Set<FssApiVersion> getSupportedVersionSet(FssApiVersion highestSupportedVersion) {
        return EnumSet.range(VERSION_211, highestSupportedVersion);
    }

    public static Set<FssApiVersion> getSupportedVersionSet(FssApiVersion lowestSupportedVersion, FssApiVersion highestSupportedVersion) {
        return EnumSet.range(lowestSupportedVersion, highestSupportedVersion);
    }
}

