/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.accounts;

import com.google.common.base.Suppliers;
import com.google.common.primitives.Longs;
import com.hedera.node.app.service.evm.contracts.execution.StaticProperties;
import java.util.Arrays;
import java.util.function.Supplier;
import org.hyperledger.besu.datatypes.Address;

public abstract class HederaEvmContractAliases {
    public static final int EVM_ADDRESS_LEN = 20;
    private static final Supplier<byte[]> MIRROR_PREFIX = Suppliers.memoize(() -> {
        byte[] result = new byte[12];
        System.arraycopy(Longs.toByteArray((long)StaticProperties.getShard()), 4, result, 0, 4);
        System.arraycopy(Longs.toByteArray((long)StaticProperties.getRealm()), 0, result, 4, 8);
        return result;
    });

    public abstract Address resolveForEvm(Address var1);

    public boolean isMirror(Address address) {
        return HederaEvmContractAliases.isMirror(address.toArrayUnsafe());
    }

    public static boolean isMirror(byte[] address) {
        if (address.length != 20) {
            return false;
        }
        return Arrays.equals(MIRROR_PREFIX.get(), 0, 12, address, 0, 12);
    }
}

