/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.store.contracts;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.hedera.node.app.service.evm.store.contracts.HederaEvmEntityAccess;
import com.hedera.node.app.service.evm.store.contracts.HederaEvmWorldStateTokenAccount;
import com.hedera.node.app.service.evm.store.contracts.utils.BytesKey;
import java.util.concurrent.TimeUnit;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.code.CodeFactory;

public class AbstractCodeCache {
    protected final HederaEvmEntityAccess entityAccess;
    protected final Cache<BytesKey, Code> cache;

    public AbstractCodeCache(int expirationCacheTime, HederaEvmEntityAccess entityAccess) {
        this.entityAccess = entityAccess;
        this.cache = Caffeine.newBuilder().expireAfterAccess((long)expirationCacheTime, TimeUnit.SECONDS).softValues().build();
    }

    public Code getIfPresent(Address address) {
        BytesKey cacheKey = new BytesKey(address.toArray());
        Code code = (Code)this.cache.getIfPresent((Object)cacheKey);
        if (code != null) {
            return code;
        }
        if (this.entityAccess.isTokenAccount(address)) {
            Bytes interpolatedBytecode = HederaEvmWorldStateTokenAccount.proxyBytecodeFor(address);
            code = CodeFactory.createCode((Bytes)interpolatedBytecode, (Hash)Hash.hash((Bytes)interpolatedBytecode), (int)0, (boolean)false);
            this.cache.put((Object)cacheKey, (Object)code);
            return code;
        }
        Bytes bytecode = this.entityAccess.fetchCodeIfPresent(address);
        if (bytecode != null) {
            code = CodeFactory.createCode((Bytes)bytecode, (Hash)Hash.hash((Bytes)bytecode), (int)0, (boolean)false);
            this.cache.put((Object)cacheKey, (Object)code);
        }
        return code;
    }

    public void invalidate(Address address) {
        this.cache.invalidate((Object)new BytesKey(address.toArray()));
    }

    public long size() {
        return this.cache.estimatedSize();
    }
}

