/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.store.contracts;

import com.hedera.node.app.service.evm.accounts.AccountAccessor;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.account.EvmAccount;
import org.hyperledger.besu.evm.worldstate.WorldUpdater;

public abstract class AbstractLedgerEvmWorldUpdater
implements WorldUpdater {
    protected final AccountAccessor accountAccessor;

    protected AbstractLedgerEvmWorldUpdater(AccountAccessor accountAccessor) {
        this.accountAccessor = accountAccessor;
    }

    public EvmAccount createAccount(Address address, long nonce, Wei balance) {
        return null;
    }

    public void deleteAccount(Address address) {
    }

    public Collection<? extends Account> getTouchedAccounts() {
        return Collections.emptyList();
    }

    public Collection<Address> getDeletedAccountAddresses() {
        return Collections.emptyList();
    }

    public void revert() {
    }

    public void commit() {
    }

    public Optional<WorldUpdater> parentUpdater() {
        return Optional.empty();
    }

    public WorldUpdater updater() {
        return this;
    }

    public boolean isTokenAddress(Address address) {
        return this.accountAccessor.isTokenAddress(address);
    }
}

