/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.store.contracts;

import com.hedera.node.app.service.evm.accounts.AccountAccessor;
import com.hedera.node.app.service.evm.store.contracts.AbstractLedgerEvmWorldUpdater;
import com.hedera.node.app.service.evm.store.contracts.HederaEvmEntityAccess;
import com.hedera.node.app.service.evm.store.models.UpdatedHederaEvmAccount;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.account.EvmAccount;

public class HederaEvmStackedWorldStateUpdater
extends AbstractLedgerEvmWorldUpdater {
    protected final HederaEvmEntityAccess hederaEvmEntityAccess;

    public HederaEvmStackedWorldStateUpdater(AccountAccessor accountAccessor, HederaEvmEntityAccess hederaEvmEntityAccess) {
        super(accountAccessor);
        this.hederaEvmEntityAccess = hederaEvmEntityAccess;
    }

    public Account get(Address address) {
        if (!address.equals((Object)this.accountAccessor.canonicalAddress(address))) {
            return null;
        }
        Wei accountBalance = Wei.of((long)this.hederaEvmEntityAccess.getBalance(address));
        UpdatedHederaEvmAccount account = new UpdatedHederaEvmAccount(address);
        account.setBalance(accountBalance);
        account.setEvmEntityAccess(this.hederaEvmEntityAccess);
        return account;
    }

    public EvmAccount getAccount(Address address) {
        return (EvmAccount)this.get(address);
    }
}

