/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.store.contracts;

import com.hedera.node.app.service.evm.accounts.AccountAccessor;
import com.hedera.node.app.service.evm.contracts.execution.EvmProperties;
import com.hedera.node.app.service.evm.store.contracts.AbstractCodeCache;
import com.hedera.node.app.service.evm.store.contracts.HederaEvmEntityAccess;
import com.hedera.node.app.service.evm.store.contracts.HederaEvmMutableWorldState;
import com.hedera.node.app.service.evm.store.contracts.HederaEvmStackedWorldStateUpdater;
import com.hedera.node.app.service.evm.store.contracts.HederaEvmWorldStateTokenAccount;
import com.hedera.node.app.service.evm.store.contracts.HederaEvmWorldUpdater;
import com.hedera.node.app.service.evm.store.contracts.WorldStateAccount;
import java.util.stream.Stream;
import org.apache.tuweni.bytes.Bytes32;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.worldstate.WorldState;
import org.hyperledger.besu.evm.worldstate.WorldUpdater;

public class HederaEvmWorldState
implements HederaEvmMutableWorldState {
    private final HederaEvmEntityAccess hederaEvmEntityAccess;
    private final EvmProperties evmProperties;
    private final AbstractCodeCache abstractCodeCache;
    private AccountAccessor accountAccessor;

    public HederaEvmWorldState(HederaEvmEntityAccess hederaEvmEntityAccess, EvmProperties evmProperties, AbstractCodeCache abstractCodeCache) {
        this.hederaEvmEntityAccess = hederaEvmEntityAccess;
        this.evmProperties = evmProperties;
        this.abstractCodeCache = abstractCodeCache;
    }

    public HederaEvmWorldState(HederaEvmEntityAccess hederaEvmEntityAccess, EvmProperties evmProperties, AbstractCodeCache abstractCodeCache, AccountAccessor accountAccessor) {
        this(hederaEvmEntityAccess, evmProperties, abstractCodeCache);
        this.accountAccessor = accountAccessor;
    }

    public Account get(Address address) {
        if (address == null) {
            return null;
        }
        if (this.hederaEvmEntityAccess.isTokenAccount(address) && this.evmProperties.isRedirectTokenCallsEnabled()) {
            return new HederaEvmWorldStateTokenAccount(address);
        }
        if (!this.hederaEvmEntityAccess.isUsable(address)) {
            return null;
        }
        long balance = this.hederaEvmEntityAccess.getBalance(address);
        return new WorldStateAccount(address, Wei.of((long)balance), this.abstractCodeCache, this.hederaEvmEntityAccess);
    }

    public Hash rootHash() {
        return Hash.EMPTY;
    }

    public Hash frontierRootHash() {
        return this.rootHash();
    }

    public Stream<WorldState.StreamableAccount> streamAccounts(Bytes32 startKeyHash, int limit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HederaEvmWorldUpdater updater() {
        return new Updater(this.accountAccessor, this.hederaEvmEntityAccess);
    }

    public static class Updater
    extends HederaEvmStackedWorldStateUpdater
    implements HederaEvmWorldUpdater {
        protected Updater(AccountAccessor accountAccessor, HederaEvmEntityAccess hederaEvmEntityAccess) {
            super(accountAccessor, hederaEvmEntityAccess);
        }

        @Override
        public long getSbhRefund() {
            return 0L;
        }

        @Override
        public WorldUpdater updater() {
            return new HederaEvmStackedWorldStateUpdater(this.accountAccessor, this.hederaEvmEntityAccess);
        }
    }
}

