/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.store.contracts;

import java.util.NavigableMap;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.account.AccountStorageEntry;
import org.hyperledger.besu.evm.code.CodeFactory;

public class HederaEvmWorldStateTokenAccount
implements Account {
    private static final String TOKEN_BYTECODE_PATTERN = "fefefefefefefefefefefefefefefefefefefefe";
    private static final String TOKEN_CALL_REDIRECT_CONTRACT_BINARY = "6080604052348015600f57600080fd5b506000610167905077618dc65efefefefefefefefefefefefefefefefefefefefe600052366000602037600080366018016008845af43d806000803e8160008114605857816000f35b816000fdfea2646970667358221220d8378feed472ba49a0005514ef7087017f707b45fb9bf56bb81bb93ff19a238b64736f6c634300080b0033";
    public static final long TOKEN_PROXY_ACCOUNT_NONCE = -1L;
    private Code interpolatedCode;
    private final Address address;

    public HederaEvmWorldStateTokenAccount(Address address) {
        this.address = address;
    }

    public Bytes getCode() {
        return this.interpolatedCode().getContainerBytes();
    }

    public long getNonce() {
        return -1L;
    }

    public Address getAddress() {
        return this.address;
    }

    public Wei getBalance() {
        return Wei.ZERO;
    }

    public Hash getAddressHash() {
        return Hash.EMPTY;
    }

    public Hash getCodeHash() {
        return this.interpolatedCode().getCodeHash();
    }

    public UInt256 getStorageValue(UInt256 ignoredKey) {
        return UInt256.ZERO;
    }

    public UInt256 getOriginalStorageValue(UInt256 ignoredKey) {
        return UInt256.ZERO;
    }

    public NavigableMap<Bytes32, AccountStorageEntry> storageEntriesFrom(Bytes32 bytes32, int i) {
        throw new UnsupportedOperationException();
    }

    public boolean hasCode() {
        return true;
    }

    public boolean isEmpty() {
        return false;
    }

    private Code interpolatedCode() {
        if (this.interpolatedCode == null) {
            Bytes interpolatedBytecode = HederaEvmWorldStateTokenAccount.proxyBytecodeFor(this.address);
            this.interpolatedCode = CodeFactory.createCode((Bytes)interpolatedBytecode, (Hash)Hash.hash((Bytes)interpolatedBytecode), (int)0, (boolean)false);
        }
        return this.interpolatedCode;
    }

    public static Bytes proxyBytecodeFor(Address address) {
        return Bytes.fromHexString((CharSequence)TOKEN_CALL_REDIRECT_CONTRACT_BINARY.replace(TOKEN_BYTECODE_PATTERN, address.toUnprefixedHexString()));
    }
}

