/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.store.models;

import com.hedera.node.app.service.evm.store.contracts.HederaEvmEntityAccess;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.ModificationNotAllowedException;
import org.hyperledger.besu.evm.account.AccountStorageEntry;
import org.hyperledger.besu.evm.account.EvmAccount;
import org.hyperledger.besu.evm.account.MutableAccount;

public class UpdatedHederaEvmAccount
implements MutableAccount,
EvmAccount {
    protected Hash addressHash;
    private Address address;
    private long nonce;
    private Wei balance;
    private HederaEvmEntityAccess hederaEvmEntityAccess;
    protected final NavigableMap<UInt256, UInt256> updatedStorage;
    @Nullable
    protected Bytes updatedCode;
    @Nullable
    private Hash updatedCodeHash;

    public UpdatedHederaEvmAccount(Address address) {
        this(address, 0L, Wei.ZERO);
        this.updatedCode = Bytes.EMPTY;
    }

    public UpdatedHederaEvmAccount(Address address, long nonce, Wei balance) {
        this.address = address;
        this.addressHash = Hash.hash((Bytes)address);
        this.nonce = nonce;
        this.balance = balance;
        this.updatedStorage = new TreeMap<UInt256, UInt256>();
        this.updatedCode = null;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Hash getAddressHash() {
        return this.addressHash;
    }

    public Wei getBalance() {
        return this.balance;
    }

    public void setBalance(Wei amount) {
        this.balance = amount;
    }

    public Bytes getCode() {
        return this.updatedCode;
    }

    public Hash getCodeHash() {
        if (this.updatedCodeHash == null) {
            this.updatedCodeHash = Hash.hash((Bytes)this.updatedCode);
        }
        return this.updatedCodeHash;
    }

    public long getNonce() {
        return this.nonce;
    }

    public void setNonce(long value) {
        this.nonce = value;
    }

    public UInt256 getOriginalStorageValue(UInt256 key) {
        return this.getStorageValue(key);
    }

    public Map<UInt256, UInt256> getUpdatedStorage() {
        return this.updatedStorage;
    }

    public UInt256 getStorageValue(UInt256 key) {
        UInt256 value = (UInt256)this.updatedStorage.get(key);
        if (value != null) {
            return value;
        }
        if (this.hederaEvmEntityAccess != null) {
            value = UInt256.fromBytes((Bytes)this.hederaEvmEntityAccess.getStorage(this.address, (Bytes)key.toBytes()));
        }
        if (value != null) {
            this.setStorageValue(key, value);
            return value;
        }
        return UInt256.ZERO;
    }

    public void setCode(Bytes code) {
        this.updatedCode = code;
        this.updatedCodeHash = null;
    }

    public void setStorageValue(UInt256 key, UInt256 value) {
        this.updatedStorage.put(key, value);
    }

    public void clearStorage() {
        this.updatedStorage.clear();
    }

    public NavigableMap<Bytes32, AccountStorageEntry> storageEntriesFrom(Bytes32 startKeyHash, int limit) {
        return Collections.emptyNavigableMap();
    }

    public MutableAccount getMutable() throws ModificationNotAllowedException {
        return this;
    }

    public void setEvmEntityAccess(HederaEvmEntityAccess hederaEvmEntityAccess) {
        this.hederaEvmEntityAccess = hederaEvmEntityAccess;
    }
}

