/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.contracts.operations;

import com.hedera.node.app.service.evm.contracts.execution.EvmProperties;
import javax.inject.Inject;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class HederaEvmChainIdOperation
extends AbstractOperation {
    final EvmProperties evmProperties;
    final Operation.OperationResult successResponse;
    private final Operation.OperationResult oogResponse;
    private final long gasCost;

    @Inject
    public HederaEvmChainIdOperation(GasCalculator gasCalculator, EvmProperties evmProperties) {
        super(70, "CHAINID", 0, 1, gasCalculator);
        this.evmProperties = evmProperties;
        this.gasCost = gasCalculator.getBaseTierGasCost();
        this.successResponse = new Operation.OperationResult(this.gasCost, null);
        this.oogResponse = new Operation.OperationResult(this.gasCost, ExceptionalHaltReason.INSUFFICIENT_GAS);
    }

    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        if (frame.getRemainingGas() < this.gasCost) {
            return this.oogResponse;
        }
        frame.pushStackItem((Bytes)this.evmProperties.chainIdBytes32());
        return this.successResponse;
    }
}

