/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.contracts.operations;

import com.hedera.node.app.service.evm.contracts.operations.AbstractEvmRecordingCreateOperation;
import com.hedera.node.app.service.evm.contracts.operations.CreateOperationExternalizer;
import com.hedera.node.app.service.evm.store.contracts.HederaEvmWorldUpdater;
import javax.inject.Inject;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;

public class HederaEvmCreateOperation
extends AbstractEvmRecordingCreateOperation {
    @Inject
    public HederaEvmCreateOperation(GasCalculator gasCalculator, CreateOperationExternalizer createOperationExternalizer) {
        super(240, "\u0127CREATE", 3, 1, gasCalculator, createOperationExternalizer);
    }

    @Override
    public long cost(MessageFrame frame) {
        return this.gasCalculator().createOperationGasCost(frame);
    }

    @Override
    protected boolean isEnabled() {
        return true;
    }

    @Override
    protected Address targetContractAddress(MessageFrame frame) {
        HederaEvmWorldUpdater updater = (HederaEvmWorldUpdater)frame.getWorldUpdater();
        Address address = updater.newContractAddress(frame.getRecipientAddress());
        frame.warmUpAddress(address);
        return address;
    }
}

