/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.exceptions;

import com.hederahashgraph.api.proto.java.ResponseCodeEnum;
import org.apache.tuweni.bytes.Bytes;

public class InvalidTransactionException
extends RuntimeException {
    private final ResponseCodeEnum responseCode;
    private final boolean reverting;

    public InvalidTransactionException(ResponseCodeEnum responseCode) {
        this(responseCode.name(), responseCode, false);
    }

    public InvalidTransactionException(ResponseCodeEnum responseCode, boolean reverting) {
        this(responseCode.name(), responseCode, reverting);
    }

    public InvalidTransactionException(String detailMessage, ResponseCodeEnum responseCode) {
        this(detailMessage, responseCode, false);
    }

    public InvalidTransactionException(String detailMessage, ResponseCodeEnum responseCode, boolean reverting) {
        super(detailMessage);
        this.responseCode = responseCode;
        this.reverting = reverting;
    }

    public ResponseCodeEnum getResponseCode() {
        return this.responseCode;
    }

    public boolean isReverting() {
        return this.reverting;
    }

    public Bytes getRevertReason() {
        if (!this.isReverting()) {
            throw new IllegalStateException();
        }
        return this.messageBytes();
    }

    public Bytes messageBytes() {
        String detail = this.getMessage();
        return Bytes.of((byte[])detail.getBytes());
    }
}

