/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.store.contracts.precompile.codec;

import java.util.Objects;
import org.hyperledger.besu.datatypes.Address;

public class FractionalFee {
    private final long numerator;
    private final long denominator;
    private final long getMinimumAmount;
    private final long getMaximumAmount;
    private final boolean netOfTransfers;
    private final Address feeCollector;

    public FractionalFee(long numerator, long denominator, long getMinimumAmount, long getMaximumAmount, boolean netOfTransfers, Address feeCollector) {
        this.numerator = numerator;
        this.denominator = denominator;
        this.getMinimumAmount = getMinimumAmount;
        this.getMaximumAmount = getMaximumAmount;
        this.netOfTransfers = netOfTransfers;
        this.feeCollector = feeCollector;
    }

    public long getMinimumAmount() {
        return this.getMinimumAmount;
    }

    public long getMaximumAmount() {
        return this.getMaximumAmount;
    }

    public long getNumerator() {
        return this.numerator;
    }

    public long getDenominator() {
        return this.denominator;
    }

    public boolean getNetOfTransfers() {
        return this.netOfTransfers;
    }

    public Address getFeeCollector() {
        return this.feeCollector != null ? this.feeCollector : Address.ZERO;
    }

    public int hashCode() {
        return Objects.hash(this.numerator, this.denominator, this.getMinimumAmount, this.getMaximumAmount, this.netOfTransfers, this.feeCollector);
    }

    public boolean equals(Object o) {
        if (o == null || FractionalFee.class != o.getClass()) {
            return false;
        }
        FractionalFee other = (FractionalFee)o;
        return this.numerator == other.numerator && this.denominator == other.denominator && this.getMinimumAmount == other.getMinimumAmount && this.getMaximumAmount == other.getMaximumAmount && this.netOfTransfers == other.netOfTransfers;
    }

    public String toString() {
        return "FractionalFee{numerator=" + this.numerator + ", denominator=" + this.denominator + ", getMinimumAmount=" + this.getMinimumAmount + ", getMaximumAmount=" + this.getMaximumAmount + ", netOfTransfers=" + this.netOfTransfers + ", feeCollector=" + this.feeCollector + "}";
    }
}

