/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.store.contracts.precompile.proxy;

import com.hedera.node.app.service.evm.exceptions.InvalidTransactionException;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.EvmEncodingFacade;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.EvmKey;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.EvmNftInfo;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.EvmTokenInfo;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.GetTokenDefaultFreezeStatusWrapper;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.GetTokenDefaultKycStatusWrapper;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.GetTokenExpiryInfoWrapper;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.GetTokenKeyWrapper;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.GrantRevokeKycWrapper;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.TokenExpiryInfo;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.TokenFreezeUnfreezeWrapper;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.TokenGetCustomFeesWrapper;
import com.hedera.node.app.service.evm.store.contracts.precompile.codec.TokenInfoWrapper;
import com.hedera.node.app.service.evm.store.contracts.precompile.impl.EvmFungibleTokenInfoPrecompile;
import com.hedera.node.app.service.evm.store.contracts.precompile.impl.EvmGetTokenDefaultFreezeStatus;
import com.hedera.node.app.service.evm.store.contracts.precompile.impl.EvmGetTokenDefaultKycStatus;
import com.hedera.node.app.service.evm.store.contracts.precompile.impl.EvmGetTokenExpiryInfoPrecompile;
import com.hedera.node.app.service.evm.store.contracts.precompile.impl.EvmGetTokenKeyPrecompile;
import com.hedera.node.app.service.evm.store.contracts.precompile.impl.EvmGetTokenTypePrecompile;
import com.hedera.node.app.service.evm.store.contracts.precompile.impl.EvmIsFrozenPrecompile;
import com.hedera.node.app.service.evm.store.contracts.precompile.impl.EvmIsKycPrecompile;
import com.hedera.node.app.service.evm.store.contracts.precompile.impl.EvmIsTokenPrecompile;
import com.hedera.node.app.service.evm.store.contracts.precompile.impl.EvmNonFungibleTokenInfoPrecompile;
import com.hedera.node.app.service.evm.store.contracts.precompile.impl.EvmTokenGetCustomFeesPrecompile;
import com.hedera.node.app.service.evm.store.contracts.precompile.impl.EvmTokenInfoPrecompile;
import com.hedera.node.app.service.evm.store.contracts.precompile.proxy.RedirectViewExecutor;
import com.hedera.node.app.service.evm.store.contracts.precompile.proxy.ViewGasCalculator;
import com.hedera.node.app.service.evm.store.contracts.utils.DescriptorUtils;
import com.hedera.node.app.service.evm.store.tokens.TokenAccessor;
import com.hedera.node.app.service.evm.store.tokens.TokenType;
import com.hedera.node.app.service.evm.utils.ValidationUtils;
import com.hederahashgraph.api.proto.java.ResponseCodeEnum;
import com.hederahashgraph.api.proto.java.Timestamp;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class ViewExecutor {
    private final Bytes input;
    private final MessageFrame frame;
    private final EvmEncodingFacade evmEncoder;
    private final ViewGasCalculator gasCalculator;
    private final TokenAccessor tokenAccessor;

    public ViewExecutor(Bytes input, MessageFrame frame, EvmEncodingFacade evmEncoder, ViewGasCalculator gasCalculator, TokenAccessor tokenAccessor) {
        this.input = input;
        this.frame = frame;
        this.evmEncoder = evmEncoder;
        this.gasCalculator = gasCalculator;
        this.tokenAccessor = tokenAccessor;
    }

    public Pair<Long, Bytes> computeCosted() {
        Timestamp now = RedirectViewExecutor.asSecondsTimestamp(this.frame.getBlockValues().getTimestamp());
        long costInGas = this.gasCalculator.compute(now, 100L);
        int selector = this.input.getInt(0);
        try {
            Bytes answer = this.answerGiven(selector);
            return Pair.of((Object)costInGas, (Object)answer);
        }
        catch (InvalidTransactionException e) {
            if (e.isReverting()) {
                this.frame.setRevertReason(e.getRevertReason());
                this.frame.setState(MessageFrame.State.REVERT);
            }
            return Pair.of((Object)costInGas, null);
        }
    }

    private Bytes answerGiven(int selector) {
        switch (selector) {
            case 526997087: {
                TokenInfoWrapper<byte[]> wrapper = EvmTokenInfoPrecompile.decodeGetTokenInfo(this.input);
                EvmTokenInfo tokenInfo = this.tokenAccessor.evmInfoForToken(DescriptorUtils.addressFromBytes(wrapper.token())).orElse(null);
                ValidationUtils.validateTrueOrRevert(tokenInfo != null, ResponseCodeEnum.INVALID_TOKEN_ID);
                return this.evmEncoder.encodeGetTokenInfo(tokenInfo);
            }
            case 1059627419: {
                TokenInfoWrapper<byte[]> wrapper = EvmFungibleTokenInfoPrecompile.decodeGetFungibleTokenInfo(this.input);
                EvmTokenInfo tokenInfo = this.tokenAccessor.evmInfoForToken(DescriptorUtils.addressFromBytes(wrapper.token())).orElse(null);
                ValidationUtils.validateTrueOrRevert(tokenInfo != null, ResponseCodeEnum.INVALID_TOKEN_ID);
                return this.evmEncoder.encodeGetFungibleTokenInfo(tokenInfo);
            }
            case 679353768: {
                TokenInfoWrapper<byte[]> wrapper = EvmNonFungibleTokenInfoPrecompile.decodeGetNonFungibleTokenInfo(this.input);
                EvmTokenInfo tokenInfo = this.tokenAccessor.evmInfoForToken(DescriptorUtils.addressFromBytes(wrapper.token())).orElse(null);
                ValidationUtils.validateTrueOrRevert(tokenInfo != null, ResponseCodeEnum.INVALID_TOKEN_ID);
                Address nftAddress = DescriptorUtils.addressFromBytes(wrapper.token());
                long serialNo = wrapper.serialNumber();
                EvmNftInfo nonFungibleTokenInfo = this.tokenAccessor.evmNftInfo(nftAddress, serialNo).orElse(null);
                ValidationUtils.validateTrueOrRevert(nonFungibleTokenInfo != null, ResponseCodeEnum.INVALID_TOKEN_NFT_SERIAL_NUMBER);
                return this.evmEncoder.encodeGetNonFungibleTokenInfo(tokenInfo, nonFungibleTokenInfo);
            }
            case 1188958129: {
                TokenFreezeUnfreezeWrapper<byte[], byte[]> wrapper = EvmIsFrozenPrecompile.decodeIsFrozen(this.input);
                ValidationUtils.validateTrueOrRevert(this.tokenAccessor.isTokenAddress(DescriptorUtils.addressFromBytes(wrapper.token())), ResponseCodeEnum.INVALID_TOKEN_ID);
                boolean isFrozen = this.tokenAccessor.isFrozen(DescriptorUtils.addressFromBytes(wrapper.account()), DescriptorUtils.addressFromBytes(wrapper.token()));
                return this.evmEncoder.encodeIsFrozen(isFrozen);
            }
            case -1478844019: {
                GetTokenDefaultFreezeStatusWrapper<byte[]> wrapper = EvmGetTokenDefaultFreezeStatus.decodeTokenDefaultFreezeStatus(this.input);
                ValidationUtils.validateTrueOrRevert(this.tokenAccessor.isTokenAddress(DescriptorUtils.addressFromBytes(wrapper.token())), ResponseCodeEnum.INVALID_TOKEN_ID);
                boolean defaultFreezeStatus = this.tokenAccessor.defaultFreezeStatus(DescriptorUtils.addressFromBytes(wrapper.token()));
                return this.evmEncoder.encodeGetTokenDefaultFreezeStatus(defaultFreezeStatus);
            }
            case 861799617: {
                GetTokenDefaultKycStatusWrapper<byte[]> wrapper = EvmGetTokenDefaultKycStatus.decodeTokenDefaultKycStatus(this.input);
                ValidationUtils.validateTrueOrRevert(this.tokenAccessor.isTokenAddress(DescriptorUtils.addressFromBytes(wrapper.token())), ResponseCodeEnum.INVALID_TOKEN_ID);
                boolean defaultKycStatus = this.tokenAccessor.defaultKycStatus(DescriptorUtils.addressFromBytes(wrapper.token()));
                return this.evmEncoder.encodeGetTokenDefaultKycStatus(defaultKycStatus);
            }
            case -222093324: {
                GrantRevokeKycWrapper<byte[], byte[]> wrapper = EvmIsKycPrecompile.decodeIsKyc(this.input);
                ValidationUtils.validateTrueOrRevert(this.tokenAccessor.isTokenAddress(DescriptorUtils.addressFromBytes(wrapper.token())), ResponseCodeEnum.INVALID_TOKEN_ID);
                boolean isKyc = this.tokenAccessor.isKyc(DescriptorUtils.addressFromBytes(wrapper.account()), DescriptorUtils.addressFromBytes(wrapper.token()));
                return this.evmEncoder.encodeIsKyc(isKyc);
            }
            case -1367993952: {
                TokenGetCustomFeesWrapper<byte[]> wrapper = EvmTokenGetCustomFeesPrecompile.decodeTokenGetCustomFees(this.input);
                List customFees = this.tokenAccessor.infoForTokenCustomFees(DescriptorUtils.addressFromBytes(wrapper.token())).orElse(null);
                ValidationUtils.validateTrueOrRevert(customFees != null, ResponseCodeEnum.INVALID_TOKEN_ID);
                return this.evmEncoder.encodeTokenGetCustomFees(customFees);
            }
            case 435385185: {
                TokenInfoWrapper<byte[]> wrapper = EvmIsTokenPrecompile.decodeIsToken(this.input);
                ValidationUtils.validateTrueOrRevert(this.tokenAccessor.isTokenAddress(DescriptorUtils.addressFromBytes(wrapper.token())), ResponseCodeEnum.INVALID_TOKEN_ID);
                boolean isToken = this.tokenAccessor.isTokenAddress(DescriptorUtils.addressFromBytes(wrapper.token()));
                return this.evmEncoder.encodeIsToken(isToken);
            }
            case -1826149457: {
                TokenInfoWrapper<byte[]> wrapper = EvmGetTokenTypePrecompile.decodeGetTokenType(this.input);
                ValidationUtils.validateTrueOrRevert(this.tokenAccessor.isTokenAddress(DescriptorUtils.addressFromBytes(wrapper.token())), ResponseCodeEnum.INVALID_TOKEN_ID);
                TokenType tokenType = this.tokenAccessor.typeOf(DescriptorUtils.addressFromBytes(wrapper.token()));
                return this.evmEncoder.encodeGetTokenType(tokenType.ordinal());
            }
            case -703279688: {
                GetTokenExpiryInfoWrapper<byte[]> wrapper = EvmGetTokenExpiryInfoPrecompile.decodeGetTokenExpiryInfo(this.input);
                EvmTokenInfo tokenInfo = this.tokenAccessor.evmInfoForToken(DescriptorUtils.addressFromBytes(wrapper.token())).orElse(null);
                ValidationUtils.validateTrueOrRevert(tokenInfo != null, ResponseCodeEnum.INVALID_TOKEN_ID);
                Objects.requireNonNull(tokenInfo);
                TokenExpiryInfo expiryInfo = new TokenExpiryInfo(tokenInfo.getExpiry(), tokenInfo.getAutoRenewAccount(), tokenInfo.getAutoRenewPeriod());
                return this.evmEncoder.encodeGetTokenExpiryInfo(expiryInfo);
            }
            case 1011733294: {
                GetTokenKeyWrapper<byte[]> wrapper = EvmGetTokenKeyPrecompile.decodeGetTokenKey(this.input);
                ValidationUtils.validateTrueOrRevert(this.tokenAccessor.isTokenAddress(DescriptorUtils.addressFromBytes(wrapper.token())), ResponseCodeEnum.INVALID_TOKEN_ID);
                EvmKey evmKey = this.tokenAccessor.keyOf(DescriptorUtils.addressFromBytes(wrapper.token()), wrapper.tokenKeyType());
                return this.evmEncoder.encodeGetTokenKey(evmKey);
            }
        }
        throw new InvalidTransactionException(ResponseCodeEnum.NOT_SUPPORTED);
    }
}

