/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.contracts.execution;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.log.Log;

public class HederaEvmTransactionProcessingResult {
    private final long gasUsed;
    private final long sbhRefund;
    private final long gasPrice;
    private final Status status;
    private final Bytes output;
    private final List<Log> logs;
    private final Optional<Bytes> revertReason;
    private final Optional<Address> recipient;
    private final Optional<ExceptionalHaltReason> haltReason;

    public static HederaEvmTransactionProcessingResult failed(long gasUsed, long sbhRefund, long gasPrice, Optional<Bytes> revertReason, Optional<ExceptionalHaltReason> haltReason) {
        return new HederaEvmTransactionProcessingResult(Status.FAILED, Collections.emptyList(), gasUsed, sbhRefund, gasPrice, Bytes.EMPTY, Optional.empty(), revertReason, haltReason);
    }

    public static HederaEvmTransactionProcessingResult successful(List<Log> logs, long gasUsed, long sbhRefund, long gasPrice, Bytes output, Address recipient) {
        return new HederaEvmTransactionProcessingResult(Status.SUCCESSFUL, logs, gasUsed, sbhRefund, gasPrice, output, Optional.of(recipient), Optional.empty(), Optional.empty());
    }

    protected HederaEvmTransactionProcessingResult(Status status, List<Log> logs, long gasUsed, long sbhRefund, long gasPrice, Bytes output, Optional<Address> recipient, Optional<Bytes> revertReason, Optional<ExceptionalHaltReason> haltReason) {
        this.logs = logs;
        this.output = output;
        this.status = status;
        this.gasUsed = gasUsed;
        this.sbhRefund = sbhRefund;
        this.gasPrice = gasPrice;
        this.recipient = recipient;
        this.haltReason = haltReason;
        this.revertReason = revertReason;
    }

    public boolean isSuccessful() {
        return this.status == Status.SUCCESSFUL;
    }

    public long getGasPrice() {
        return this.gasPrice;
    }

    public long getGasUsed() {
        return this.gasUsed;
    }

    public long getSbhRefund() {
        return this.sbhRefund;
    }

    public Bytes getOutput() {
        return this.output;
    }

    public List<Log> getLogs() {
        return this.logs;
    }

    public Optional<Address> getRecipient() {
        return this.recipient;
    }

    public Optional<ExceptionalHaltReason> getHaltReason() {
        return this.haltReason;
    }

    public Optional<Bytes> getRevertReason() {
        return this.revertReason;
    }

    public static enum Status {
        SUCCESSFUL,
        FAILED;

    }
}

