/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.contracts.operations;

import com.hedera.node.app.service.evm.contracts.operations.HederaEvmOperationsUtil;
import java.util.function.BiPredicate;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.ExtCodeSizeOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class HederaExtCodeSizeOperation
extends ExtCodeSizeOperation {
    private final BiPredicate<Address, MessageFrame> addressValidator;

    public HederaExtCodeSizeOperation(GasCalculator gasCalculator, BiPredicate<Address, MessageFrame> addressValidator) {
        super(gasCalculator);
        this.addressValidator = addressValidator;
    }

    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        return HederaEvmOperationsUtil.addressCheckExecution(frame, () -> frame.getStackItem(0), () -> this.cost(true), () -> super.execute(frame, evm), this.addressValidator);
    }
}

