/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.store.contracts;

import com.hedera.node.app.service.evm.store.contracts.AbstractCodeCache;
import com.hedera.node.app.service.evm.store.contracts.HederaEvmEntityAccess;
import java.util.NavigableMap;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.account.AccountStorageEntry;
import org.hyperledger.besu.evm.code.CodeFactory;

public class WorldStateAccount
implements Account {
    private static final Code EMPTY_CODE = CodeFactory.createCode((Bytes)Bytes.EMPTY, (int)0, (boolean)false);
    private final Wei balance;
    private final Address address;
    private final AbstractCodeCache codeCache;
    private final HederaEvmEntityAccess entityAccess;

    public WorldStateAccount(Address address, Wei balance, AbstractCodeCache codeCache, HederaEvmEntityAccess entityAccess) {
        this.balance = balance;
        this.address = address;
        this.codeCache = codeCache;
        this.entityAccess = entityAccess;
    }

    public Address getAddress() {
        return this.address;
    }

    public Hash getAddressHash() {
        return Hash.EMPTY;
    }

    public long getNonce() {
        return this.entityAccess.getNonce(this.address);
    }

    public Wei getBalance() {
        return this.balance;
    }

    public Bytes getCode() {
        return this.getCodeInternal().getBytes();
    }

    public boolean hasCode() {
        return !this.getCode().isEmpty();
    }

    public Hash getCodeHash() {
        return this.getCodeInternal().getCodeHash();
    }

    public UInt256 getStorageValue(UInt256 key) {
        return UInt256.fromBytes((Bytes)this.entityAccess.getStorage(this.address, (Bytes)key));
    }

    public UInt256 getOriginalStorageValue(UInt256 key) {
        return this.getStorageValue(key);
    }

    public NavigableMap<Bytes32, AccountStorageEntry> storageEntriesFrom(Bytes32 startKeyHash, int limit) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "AccountState{address=" + this.getAddress() + ", nonce=" + this.getNonce() + ", balance=" + this.getBalance() + ", codeHash=" + this.getCodeHash() + ", }";
    }

    private Code getCodeInternal() {
        Code code = this.codeCache.getIfPresent(this.address);
        return code == null ? EMPTY_CODE : code;
    }
}

