/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.evm.store.contracts.precompile;

import com.hedera.node.app.service.evm.store.contracts.precompile.EvmInfrastructureFactory;
import com.hedera.node.app.service.evm.store.contracts.precompile.proxy.RedirectViewExecutor;
import com.hedera.node.app.service.evm.store.contracts.precompile.proxy.ViewExecutor;
import com.hedera.node.app.service.evm.store.contracts.precompile.proxy.ViewGasCalculator;
import com.hedera.node.app.service.evm.store.contracts.utils.DescriptorUtils;
import com.hedera.node.app.service.evm.store.tokens.TokenAccessor;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.precompile.PrecompiledContract;

public class EvmHTSPrecompiledContract
implements PrecompiledContract {
    private final EvmInfrastructureFactory infrastructureFactory;
    public static final String EVM_HTS_PRECOMPILED_CONTRACT_ADDRESS = "0x167";

    @Inject
    public EvmHTSPrecompiledContract(EvmInfrastructureFactory infrastructureFactory) {
        this.infrastructureFactory = infrastructureFactory;
    }

    public Pair<Long, Bytes> computeCosted(Bytes input, MessageFrame frame, ViewGasCalculator viewGasCalculator, TokenAccessor tokenAccessor) {
        if (frame.isStatic()) {
            if (DescriptorUtils.isTokenProxyRedirect(input)) {
                RedirectViewExecutor executor = this.infrastructureFactory.newRedirectExecutor(input, frame, viewGasCalculator, tokenAccessor);
                return executor.computeCosted();
            }
            if (DescriptorUtils.isViewFunction(input)) {
                ViewExecutor executor = this.infrastructureFactory.newViewExecutor(input, frame, viewGasCalculator, tokenAccessor);
                return executor.computeCosted();
            }
        }
        return Pair.of((Object)-1L, (Object)Bytes.EMPTY);
    }

    public String getName() {
        return "EvmHTS";
    }

    public long gasRequirement(Bytes input) {
        return 0L;
    }
}

